package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AdvancedBitLockerState implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("noUserConsent")
    NO_USER_CONSENT("noUserConsent", "1"),

    @JsonProperty("osVolumeEncryptionMethodMismatch")
    OS_VOLUME_ENCRYPTION_METHOD_MISMATCH("osVolumeEncryptionMethodMismatch", "2"),

    @JsonProperty("osVolumeTpmRequired")
    OS_VOLUME_TPM_REQUIRED("osVolumeTpmRequired", "4"),

    @JsonProperty("osVolumeTpmOnlyRequired")
    OS_VOLUME_TPM_ONLY_REQUIRED("osVolumeTpmOnlyRequired", "8"),

    @JsonProperty("osVolumeTpmPinRequired")
    OS_VOLUME_TPM_PIN_REQUIRED("osVolumeTpmPinRequired", "16"),

    @JsonProperty("osVolumeTpmStartupKeyRequired")
    OS_VOLUME_TPM_STARTUP_KEY_REQUIRED("osVolumeTpmStartupKeyRequired", "32"),

    @JsonProperty("osVolumeTpmPinStartupKeyRequired")
    OS_VOLUME_TPM_PIN_STARTUP_KEY_REQUIRED("osVolumeTpmPinStartupKeyRequired", "64"),

    @JsonProperty("osVolumeUnprotected")
    OS_VOLUME_UNPROTECTED("osVolumeUnprotected", "128"),

    @JsonProperty("recoveryKeyBackupFailed")
    RECOVERY_KEY_BACKUP_FAILED("recoveryKeyBackupFailed", "256"),

    @JsonProperty("fixedDriveNotEncrypted")
    FIXED_DRIVE_NOT_ENCRYPTED("fixedDriveNotEncrypted", "512"),

    @JsonProperty("fixedDriveEncryptionMethodMismatch")
    FIXED_DRIVE_ENCRYPTION_METHOD_MISMATCH("fixedDriveEncryptionMethodMismatch", "1024"),

    @JsonProperty("loggedOnUserNonAdmin")
    LOGGED_ON_USER_NON_ADMIN("loggedOnUserNonAdmin", "2048"),

    @JsonProperty("windowsRecoveryEnvironmentNotConfigured")
    WINDOWS_RECOVERY_ENVIRONMENT_NOT_CONFIGURED("windowsRecoveryEnvironmentNotConfigured", "4096"),

    @JsonProperty("tpmNotAvailable")
    TPM_NOT_AVAILABLE("tpmNotAvailable", "8192"),

    @JsonProperty("tpmNotReady")
    TPM_NOT_READY("tpmNotReady", "16384"),

    @JsonProperty("networkError")
    NETWORK_ERROR("networkError", "32768");

    private final String name;
    private final String value;

    private AdvancedBitLockerState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
