package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AdministratorConfiguredDeviceComplianceState implements Enum {

    @JsonProperty("basedOnDeviceCompliancePolicy")
    BASED_ON_DEVICE_COMPLIANCE_POLICY("basedOnDeviceCompliancePolicy", "0"),

    @JsonProperty("nonCompliant")
    NON_COMPLIANT("nonCompliant", "1");

    private final String name;
    private final String value;

    private AdministratorConfiguredDeviceComplianceState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
