package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ActionState implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("canceled")
    CANCELED("canceled", "2"),

    @JsonProperty("active")
    ACTIVE("active", "3"),

    @JsonProperty("done")
    DONE("done", "4"),

    @JsonProperty("failed")
    FAILED("failed", "5"),

    @JsonProperty("notSupported")
    NOT_SUPPORTED("notSupported", "6");

    private final String name;
    private final String value;

    private ActionState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
