package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AccessScope implements Enum {

    @JsonProperty("inOrganization")
    IN_ORGANIZATION("inOrganization", "0"),

    @JsonProperty("notInOrganization")
    NOT_IN_ORGANIZATION("notInOrganization", "1");

    private final String name;
    private final String value;

    private AccessScope(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
