package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WorkbookRange;
import odata.msgraph.client.beta.entity.WorkbookWorksheet;
import odata.msgraph.client.beta.entity.collection.request.WorkbookChartCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookNamedItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookPivotTableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookWorksheetRequest extends EntityRequest<WorkbookWorksheet> {

    public WorkbookWorksheetRequest(ContextPath contextPath) {
        super(WorkbookWorksheet.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartCollectionRequest charts() {
        return new WorkbookChartCollectionRequest(
                        contextPath.addSegment("charts"));
    }

    public WorkbookChartRequest charts(String id) {
        return new WorkbookChartRequest(contextPath.addSegment("charts").addKeys(new NameValue(id.toString())));
    }

    public WorkbookNamedItemCollectionRequest names() {
        return new WorkbookNamedItemCollectionRequest(
                        contextPath.addSegment("names"));
    }

    public WorkbookNamedItemRequest names(String id) {
        return new WorkbookNamedItemRequest(contextPath.addSegment("names").addKeys(new NameValue(id.toString())));
    }

    public WorkbookPivotTableCollectionRequest pivotTables() {
        return new WorkbookPivotTableCollectionRequest(
                        contextPath.addSegment("pivotTables"));
    }

    public WorkbookPivotTableRequest pivotTables(String id) {
        return new WorkbookPivotTableRequest(contextPath.addSegment("pivotTables").addKeys(new NameValue(id.toString())));
    }

    public WorkbookWorksheetProtectionRequest protection() {
        return new WorkbookWorksheetProtectionRequest(contextPath.addSegment("protection"));
    }

    public WorkbookTableCollectionRequest tables() {
        return new WorkbookTableCollectionRequest(
                        contextPath.addSegment("tables"));
    }

    public WorkbookTableRequest tables(String id) {
        return new WorkbookTableRequest(contextPath.addSegment("tables").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "cell")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> cell(Integer row, Integer column) {
        Preconditions.checkNotNull(row, "row cannot be null");
        Preconditions.checkNotNull(column, "column cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("row", "Edm.Int32", row)
            .put("column", "Edm.Int32", column)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cell"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range_Function(String address) {
        Preconditions.checkNotNull(address, "address cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("address", "Edm.String", Checks.checkIsAscii(address))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange_Function(Boolean valuesOnly) {
        Preconditions.checkNotNull(valuesOnly, "valuesOnly cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("valuesOnly", "Edm.Boolean", valuesOnly)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
