package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.WorkbookSortField;
import odata.msgraph.client.beta.entity.WorkbookTableSort;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookTableSortRequest extends EntityRequest<WorkbookTableSort> {

    public WorkbookTableSortRequest(ContextPath contextPath) {
        super(WorkbookTableSort.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestNoReturn apply(List<WorkbookSortField> fields, Boolean matchCase, String method) {
        Preconditions.checkNotNull(matchCase, "matchCase cannot be null");
        Preconditions.checkNotNull(method, "method cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fields", "Collection(microsoft.graph.workbookSortField)", fields)
            .put("matchCase", "Edm.Boolean", matchCase)
            .put("method", "Edm.String", Checks.checkIsAscii(method))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.apply"), _parameters);
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Action(name = "reapply")
    @JsonIgnore
    public ActionRequestNoReturn reapply() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reapply"), _parameters);
    }

}
