package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WorkbookRange;
import odata.msgraph.client.beta.entity.WorkbookTable;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableColumnCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableRowCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookTableRequest extends EntityRequest<WorkbookTable> {

    public WorkbookTableRequest(ContextPath contextPath) {
        super(WorkbookTable.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookTableColumnCollectionRequest columns() {
        return new WorkbookTableColumnCollectionRequest(
                        contextPath.addSegment("columns"));
    }

    public WorkbookTableColumnRequest columns(String id) {
        return new WorkbookTableColumnRequest(contextPath.addSegment("columns").addKeys(new NameValue(id.toString())));
    }

    public WorkbookTableRowCollectionRequest rows() {
        return new WorkbookTableRowCollectionRequest(
                        contextPath.addSegment("rows"));
    }

    public WorkbookTableRowRequest rows(String id) {
        return new WorkbookTableRowRequest(contextPath.addSegment("rows").addKeys(new NameValue(id.toString())));
    }

    public WorkbookTableSortRequest sort() {
        return new WorkbookTableSortRequest(contextPath.addSegment("sort"));
    }

    public WorkbookWorksheetRequest worksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"));
    }

    @Action(name = "clearFilters")
    @JsonIgnore
    public ActionRequestNoReturn clearFilters() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clearFilters"), _parameters);
    }

    @Action(name = "convertToRange")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookRange> convertToRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.convertToRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "reapplyFilters")
    @JsonIgnore
    public ActionRequestNoReturn reapplyFilters() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reapplyFilters"), _parameters);
    }

    @Function(name = "dataBodyRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> dataBodyRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dataBodyRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "headerRowRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> headerRowRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.headerRowRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "totalRowRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> totalRowRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.totalRowRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
