package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.WorkbookSessionInfo;
import odata.msgraph.client.beta.entity.Workbook;
import odata.msgraph.client.beta.entity.collection.request.WorkbookCommentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookNamedItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookWorksheetCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookRequest extends EntityRequest<Workbook> {

    public WorkbookRequest(ContextPath contextPath) {
        super(Workbook.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookApplicationRequest application() {
        return new WorkbookApplicationRequest(contextPath.addSegment("application"));
    }

    public WorkbookNamedItemCollectionRequest names() {
        return new WorkbookNamedItemCollectionRequest(
                        contextPath.addSegment("names"));
    }

    public WorkbookNamedItemRequest names(String id) {
        return new WorkbookNamedItemRequest(contextPath.addSegment("names").addKeys(new NameValue(id.toString())));
    }

    public WorkbookTableCollectionRequest tables() {
        return new WorkbookTableCollectionRequest(
                        contextPath.addSegment("tables"));
    }

    public WorkbookTableRequest tables(String id) {
        return new WorkbookTableRequest(contextPath.addSegment("tables").addKeys(new NameValue(id.toString())));
    }

    public WorkbookWorksheetCollectionRequest worksheets() {
        return new WorkbookWorksheetCollectionRequest(
                        contextPath.addSegment("worksheets"));
    }

    public WorkbookWorksheetRequest worksheets(String id) {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheets").addKeys(new NameValue(id.toString())));
    }

    public WorkbookCommentCollectionRequest comments() {
        return new WorkbookCommentCollectionRequest(
                        contextPath.addSegment("comments"));
    }

    public WorkbookCommentRequest comments(String id) {
        return new WorkbookCommentRequest(contextPath.addSegment("comments").addKeys(new NameValue(id.toString())));
    }

    public WorkbookFunctionsRequest functions() {
        return new WorkbookFunctionsRequest(contextPath.addSegment("functions"));
    }

    public WorkbookOperationCollectionRequest operations() {
        return new WorkbookOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    public WorkbookOperationRequest operations(String id) {
        return new WorkbookOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "createSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo> createSession(Boolean persistChanges) {
        Preconditions.checkNotNull(persistChanges, "persistChanges cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("persistChanges", "Edm.Boolean", persistChanges)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createSession"), WorkbookSessionInfo.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "closeSession")
    @JsonIgnore
    public ActionRequestNoReturn closeSession() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.closeSession"), _parameters);
    }

    @Action(name = "refreshSession")
    @JsonIgnore
    public ActionRequestNoReturn refreshSession() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refreshSession"), _parameters);
    }

    @Function(name = "sessionInfoResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo> sessionInfoResource(String key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sessionInfoResource"), WorkbookSessionInfo.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
