package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WorkbookRange;
import odata.msgraph.client.beta.entity.WorkbookRangeView;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookRangeRequest extends EntityRequest<WorkbookRange> {

    public WorkbookRangeRequest(ContextPath contextPath) {
        super(WorkbookRange.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookRangeFormatRequest format() {
        return new WorkbookRangeFormatRequest(contextPath.addSegment("format"));
    }

    public WorkbookRangeSortRequest sort() {
        return new WorkbookRangeSortRequest(contextPath.addSegment("sort"));
    }

    public WorkbookWorksheetRequest worksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"));
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear(String applyTo) {
        Preconditions.checkNotNull(applyTo, "applyTo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("applyTo", "Edm.String", Checks.checkIsAscii(applyTo))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Action(name = "delete")
    @JsonIgnore
    public ActionRequestNoReturn delete(String shift) {
        Preconditions.checkNotNull(shift, "shift cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shift", "Edm.String", Checks.checkIsAscii(shift))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delete"), _parameters);
    }

    @Action(name = "insert")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookRange> insert(String shift) {
        Preconditions.checkNotNull(shift, "shift cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shift", "Edm.String", Checks.checkIsAscii(shift))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.insert"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "merge")
    @JsonIgnore
    public ActionRequestNoReturn merge(Boolean across) {
        Preconditions.checkNotNull(across, "across cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("across", "Edm.Boolean", across)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.merge"), _parameters);
    }

    @Action(name = "unmerge")
    @JsonIgnore
    public ActionRequestNoReturn unmerge() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unmerge"), _parameters);
    }

    @Function(name = "boundingRect")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> boundingRect(String anotherRange) {
        Preconditions.checkNotNull(anotherRange, "anotherRange cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("anotherRange", "Edm.String", Checks.checkIsAscii(anotherRange))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.boundingRect"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "cell")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> cell(Integer row, Integer column) {
        Preconditions.checkNotNull(row, "row cannot be null");
        Preconditions.checkNotNull(column, "column cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("row", "Edm.Int32", row)
            .put("column", "Edm.Int32", column)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cell"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "column")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> column(Integer column) {
        Preconditions.checkNotNull(column, "column cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("column", "Edm.Int32", column)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.column"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "columnsAfter")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsAfter() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsAfter"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "columnsAfter")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsAfter_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsAfter"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "columnsBefore")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsBefore() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsBefore"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "columnsBefore")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsBefore_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsBefore"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "entireColumn")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> entireColumn() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.entireColumn"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "entireRow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> entireRow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.entireRow"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "intersection")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> intersection(String anotherRange) {
        Preconditions.checkNotNull(anotherRange, "anotherRange cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("anotherRange", "Edm.String", Checks.checkIsAscii(anotherRange))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.intersection"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "lastCell")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> lastCell() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lastCell"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "lastColumn")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> lastColumn() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lastColumn"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "lastRow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> lastRow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lastRow"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "offsetRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> offsetRange(Integer rowOffset, Integer columnOffset) {
        Preconditions.checkNotNull(rowOffset, "rowOffset cannot be null");
        Preconditions.checkNotNull(columnOffset, "columnOffset cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rowOffset", "Edm.Int32", rowOffset)
            .put("columnOffset", "Edm.Int32", columnOffset)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.offsetRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "resizedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> resizedRange(Integer deltaRows, Integer deltaColumns) {
        Preconditions.checkNotNull(deltaRows, "deltaRows cannot be null");
        Preconditions.checkNotNull(deltaColumns, "deltaColumns cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deltaRows", "Edm.Int32", deltaRows)
            .put("deltaColumns", "Edm.Int32", deltaColumns)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resizedRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "row")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> row(Integer row) {
        Preconditions.checkNotNull(row, "row cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("row", "Edm.Int32", row)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.row"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "rowsAbove")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsAbove() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsAbove"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "rowsAbove")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsAbove_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsAbove"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "rowsBelow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsBelow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsBelow"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "rowsBelow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsBelow_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsBelow"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange_Function(Boolean valuesOnly) {
        Preconditions.checkNotNull(valuesOnly, "valuesOnly cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("valuesOnly", "Edm.Boolean", valuesOnly)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "visibleView")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView> visibleView() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.visibleView"), WorkbookRangeView.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
