package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.complex.WorkbookFilterCriteria;
import odata.msgraph.client.beta.complex.WorkbookIcon;
import odata.msgraph.client.beta.entity.WorkbookFilter;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookFilterRequest extends EntityRequest<WorkbookFilter> {

    public WorkbookFilterRequest(ContextPath contextPath) {
        super(WorkbookFilter.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestNoReturn apply(WorkbookFilterCriteria criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria", "microsoft.graph.workbookFilterCriteria", criteria)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.apply"), _parameters);
    }

    @Action(name = "applyBottomItemsFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyBottomItemsFilter(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyBottomItemsFilter"), _parameters);
    }

    @Action(name = "applyBottomPercentFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyBottomPercentFilter(Integer percent) {
        Preconditions.checkNotNull(percent, "percent cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("percent", "Edm.Int32", percent)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyBottomPercentFilter"), _parameters);
    }

    @Action(name = "applyCellColorFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyCellColorFilter(String color) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("color", "Edm.String", Checks.checkIsAscii(color))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyCellColorFilter"), _parameters);
    }

    @Action(name = "applyCustomFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyCustomFilter(String criteria1, String criteria2, String oper) {
        Preconditions.checkNotNull(oper, "oper cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria1", "Edm.String", Checks.checkIsAscii(criteria1))
            .put("criteria2", "Edm.String", Checks.checkIsAscii(criteria2))
            .put("oper", "Edm.String", Checks.checkIsAscii(oper))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyCustomFilter"), _parameters);
    }

    @Action(name = "applyDynamicFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyDynamicFilter(String criteria) {
        Preconditions.checkNotNull(criteria, "criteria cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria", "Edm.String", Checks.checkIsAscii(criteria))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDynamicFilter"), _parameters);
    }

    @Action(name = "applyFontColorFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyFontColorFilter(String color) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("color", "Edm.String", Checks.checkIsAscii(color))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyFontColorFilter"), _parameters);
    }

    @Action(name = "applyIconFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyIconFilter(WorkbookIcon icon) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("icon", "microsoft.graph.workbookIcon", icon)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyIconFilter"), _parameters);
    }

    @Action(name = "applyTopItemsFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyTopItemsFilter(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyTopItemsFilter"), _parameters);
    }

    @Action(name = "applyTopPercentFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyTopPercentFilter(Integer percent) {
        Preconditions.checkNotNull(percent, "percent cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("percent", "Edm.Int32", percent)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyTopPercentFilter"), _parameters);
    }

    @Action(name = "applyValuesFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyValuesFilter(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyValuesFilter"), _parameters);
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

}
