package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WorkbookComment;
import odata.msgraph.client.beta.entity.collection.request.WorkbookCommentReplyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookCommentRequest extends EntityRequest<WorkbookComment> {

    public WorkbookCommentRequest(ContextPath contextPath) {
        super(WorkbookComment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookCommentReplyCollectionRequest replies() {
        return new WorkbookCommentReplyCollectionRequest(
                        contextPath.addSegment("replies"));
    }

    public WorkbookCommentReplyRequest replies(String id) {
        return new WorkbookCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id.toString())));
    }

}
