package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.WorkbookChartTitleFormat;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartTitleFormatRequest extends EntityRequest<WorkbookChartTitleFormat> {

    public WorkbookChartTitleFormatRequest(ContextPath contextPath) {
        super(WorkbookChartTitleFormat.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartFillRequest fill() {
        return new WorkbookChartFillRequest(contextPath.addSegment("fill"));
    }

    public WorkbookChartFontRequest font() {
        return new WorkbookChartFontRequest(contextPath.addSegment("font"));
    }

}
