package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WorkbookChartSeries;
import odata.msgraph.client.beta.entity.collection.request.WorkbookChartPointCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartSeriesRequest extends EntityRequest<WorkbookChartSeries> {

    public WorkbookChartSeriesRequest(ContextPath contextPath) {
        super(WorkbookChartSeries.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartSeriesFormatRequest format() {
        return new WorkbookChartSeriesFormatRequest(contextPath.addSegment("format"));
    }

    public WorkbookChartPointCollectionRequest points() {
        return new WorkbookChartPointCollectionRequest(
                        contextPath.addSegment("points"));
    }

    public WorkbookChartPointRequest points(String id) {
        return new WorkbookChartPointRequest(contextPath.addSegment("points").addKeys(new NameValue(id.toString())));
    }

}
