package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.WorkbookChartSeriesFormat;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartSeriesFormatRequest extends EntityRequest<WorkbookChartSeriesFormat> {

    public WorkbookChartSeriesFormatRequest(ContextPath contextPath) {
        super(WorkbookChartSeriesFormat.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartFillRequest fill() {
        return new WorkbookChartFillRequest(contextPath.addSegment("fill"));
    }

    public WorkbookChartLineFormatRequest line() {
        return new WorkbookChartLineFormatRequest(contextPath.addSegment("line"));
    }

}
