package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.WorkbookChartLegendFormat;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartLegendFormatRequest extends EntityRequest<WorkbookChartLegendFormat> {

    public WorkbookChartLegendFormatRequest(ContextPath contextPath) {
        super(WorkbookChartLegendFormat.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartFillRequest fill() {
        return new WorkbookChartFillRequest(contextPath.addSegment("fill"));
    }

    public WorkbookChartFontRequest font() {
        return new WorkbookChartFontRequest(contextPath.addSegment("font"));
    }

}
