package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.WorkbookChartAxis;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartAxisRequest extends EntityRequest<WorkbookChartAxis> {

    public WorkbookChartAxisRequest(ContextPath contextPath) {
        super(WorkbookChartAxis.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartAxisFormatRequest format() {
        return new WorkbookChartAxisFormatRequest(contextPath.addSegment("format"));
    }

    public WorkbookChartGridlinesRequest majorGridlines() {
        return new WorkbookChartGridlinesRequest(contextPath.addSegment("majorGridlines"));
    }

    public WorkbookChartGridlinesRequest minorGridlines() {
        return new WorkbookChartGridlinesRequest(contextPath.addSegment("minorGridlines"));
    }

    public WorkbookChartAxisTitleRequest title() {
        return new WorkbookChartAxisTitleRequest(contextPath.addSegment("title"));
    }

}
