package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.WorkbookChartAxisFormat;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartAxisFormatRequest extends EntityRequest<WorkbookChartAxisFormat> {

    public WorkbookChartAxisFormatRequest(ContextPath contextPath) {
        super(WorkbookChartAxisFormat.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartFontRequest font() {
        return new WorkbookChartFontRequest(contextPath.addSegment("font"));
    }

    public WorkbookChartLineFormatRequest line() {
        return new WorkbookChartLineFormatRequest(contextPath.addSegment("line"));
    }

}
