package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.WorkbookChartAxes;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WorkbookChartAxesRequest extends EntityRequest<WorkbookChartAxes> {

    public WorkbookChartAxesRequest(ContextPath contextPath) {
        super(WorkbookChartAxes.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookChartAxisRequest categoryAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("categoryAxis"));
    }

    public WorkbookChartAxisRequest seriesAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("seriesAxis"));
    }

    public WorkbookChartAxisRequest valueAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("valueAxis"));
    }

}
