package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsWifiEnterpriseEAPConfiguration;
import odata.msgraph.client.beta.entity.collection.request.Windows81TrustedRootCertificateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsWifiEnterpriseEAPConfigurationRequest extends EntityRequest<WindowsWifiEnterpriseEAPConfiguration> {

    public WindowsWifiEnterpriseEAPConfigurationRequest(ContextPath contextPath) {
        super(WindowsWifiEnterpriseEAPConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public Windows81TrustedRootCertificateCollectionRequest rootCertificatesForServerValidation() {
        return new Windows81TrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"));
    }

    public Windows81TrustedRootCertificateRequest rootCertificatesForServerValidation(String id) {
        return new Windows81TrustedRootCertificateRequest(contextPath.addSegment("rootCertificatesForServerValidation").addKeys(new NameValue(id.toString())));
    }

    public WindowsCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new WindowsCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    public Windows81TrustedRootCertificateRequest rootCertificateForClientValidation() {
        return new Windows81TrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForClientValidation"));
    }

}
