package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsUniversalAppX;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsUniversalAppXRequest extends EntityRequest<WindowsUniversalAppX> {

    public WindowsUniversalAppXRequest(ContextPath contextPath) {
        super(WindowsUniversalAppX.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MobileContainedAppCollectionRequest committedContainedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("committedContainedApps"));
    }

    public MobileContainedAppRequest committedContainedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("committedContainedApps").addKeys(new NameValue(id.toString())));
    }

}
