package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsProtectionState;
import odata.msgraph.client.beta.entity.collection.request.WindowsDeviceMalwareStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsProtectionStateRequest extends EntityRequest<WindowsProtectionState> {

    public WindowsProtectionStateRequest(ContextPath contextPath) {
        super(WindowsProtectionState.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsDeviceMalwareStateCollectionRequest detectedMalwareState() {
        return new WindowsDeviceMalwareStateCollectionRequest(
                        contextPath.addSegment("detectedMalwareState"));
    }

    public WindowsDeviceMalwareStateRequest detectedMalwareState(String id) {
        return new WindowsDeviceMalwareStateRequest(contextPath.addSegment("detectedMalwareState").addKeys(new NameValue(id.toString())));
    }

}
