package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsPhone81ImportedPFXCertificateProfile;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsPhone81ImportedPFXCertificateProfileRequest extends EntityRequest<WindowsPhone81ImportedPFXCertificateProfile> {

    public WindowsPhone81ImportedPFXCertificateProfileRequest(ContextPath contextPath) {
        super(WindowsPhone81ImportedPFXCertificateProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagedDeviceCertificateStateCollectionRequest managedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"));
    }

    public ManagedDeviceCertificateStateRequest managedDeviceCertificateStates(String id) {
        return new ManagedDeviceCertificateStateRequest(contextPath.addSegment("managedDeviceCertificateStates").addKeys(new NameValue(id.toString())));
    }

}
