package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsManagementApp;
import odata.msgraph.client.beta.entity.collection.request.WindowsManagementAppHealthStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsManagementAppRequest extends EntityRequest<WindowsManagementApp> {

    public WindowsManagementAppRequest(ContextPath contextPath) {
        super(WindowsManagementApp.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsManagementAppHealthStateCollectionRequest healthStates() {
        return new WindowsManagementAppHealthStateCollectionRequest(
                        contextPath.addSegment("healthStates"));
    }

    public WindowsManagementAppHealthStateRequest healthStates(String id) {
        return new WindowsManagementAppHealthStateRequest(contextPath.addSegment("healthStates").addKeys(new NameValue(id.toString())));
    }

}
