package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsMalwareInformation;
import odata.msgraph.client.beta.entity.collection.request.WindowsProtectionStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsMalwareInformationRequest extends EntityRequest<WindowsMalwareInformation> {

    public WindowsMalwareInformationRequest(ContextPath contextPath) {
        super(WindowsMalwareInformation.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsProtectionStateCollectionRequest windowsDevicesProtectionState() {
        return new WindowsProtectionStateCollectionRequest(
                        contextPath.addSegment("windowsDevicesProtectionState"));
    }

    public WindowsProtectionStateRequest windowsDevicesProtectionState(String id) {
        return new WindowsProtectionStateRequest(contextPath.addSegment("windowsDevicesProtectionState").addKeys(new NameValue(id.toString())));
    }

}
