package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.TargetedManagedAppPolicyAssignment;
import odata.msgraph.client.beta.entity.WindowsInformationProtection;
import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionAppLockerFileCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsInformationProtectionRequest extends EntityRequest<WindowsInformationProtection> {

    public WindowsInformationProtectionRequest(ContextPath contextPath) {
        super(WindowsInformationProtection.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsInformationProtectionAppLockerFileCollectionRequest protectedAppLockerFiles() {
        return new WindowsInformationProtectionAppLockerFileCollectionRequest(
                        contextPath.addSegment("protectedAppLockerFiles"));
    }

    public WindowsInformationProtectionAppLockerFileRequest protectedAppLockerFiles(String id) {
        return new WindowsInformationProtectionAppLockerFileRequest(contextPath.addSegment("protectedAppLockerFiles").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionAppLockerFileCollectionRequest exemptAppLockerFiles() {
        return new WindowsInformationProtectionAppLockerFileCollectionRequest(
                        contextPath.addSegment("exemptAppLockerFiles"));
    }

    public WindowsInformationProtectionAppLockerFileRequest exemptAppLockerFiles(String id) {
        return new WindowsInformationProtectionAppLockerFileRequest(contextPath.addSegment("exemptAppLockerFiles").addKeys(new NameValue(id.toString())));
    }

    public TargetedManagedAppPolicyAssignmentCollectionRequest assignments() {
        return new TargetedManagedAppPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public TargetedManagedAppPolicyAssignmentRequest assignments(String id) {
        return new TargetedManagedAppPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<TargetedManagedAppPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.targetedManagedAppPolicyAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
