package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.WindowsFeatureUpdateProfile;
import odata.msgraph.client.beta.entity.WindowsFeatureUpdateProfileAssignment;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsUpdateStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsFeatureUpdateProfileRequest extends EntityRequest<WindowsFeatureUpdateProfile> {

    public WindowsFeatureUpdateProfileRequest(ContextPath contextPath) {
        super(WindowsFeatureUpdateProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsFeatureUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsFeatureUpdateProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public WindowsFeatureUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsFeatureUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public WindowsUpdateStateCollectionRequest deviceUpdateStates() {
        return new WindowsUpdateStateCollectionRequest(
                        contextPath.addSegment("deviceUpdateStates"));
    }

    public WindowsUpdateStateRequest deviceUpdateStates(String id) {
        return new WindowsUpdateStateRequest(contextPath.addSegment("deviceUpdateStates").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsFeatureUpdateProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.windowsFeatureUpdateProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
