package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsDomainJoinConfiguration;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsDomainJoinConfigurationRequest extends EntityRequest<WindowsDomainJoinConfiguration> {

    public WindowsDomainJoinConfigurationRequest(ContextPath contextPath) {
        super(WindowsDomainJoinConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceConfigurationCollectionRequest networkAccessConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("networkAccessConfigurations"));
    }

    public DeviceConfigurationRequest networkAccessConfigurations(String id) {
        return new DeviceConfigurationRequest(contextPath.addSegment("networkAccessConfigurations").addKeys(new NameValue(id.toString())));
    }

}
