package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WindowsAutopilotSettings;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsAutopilotSettingsRequest extends EntityRequest<WindowsAutopilotSettings> {

    public WindowsAutopilotSettingsRequest(ContextPath contextPath) {
        super(WindowsAutopilotSettings.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "sync")
    @JsonIgnore
    public ActionRequestNoReturn sync() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sync"), _parameters);
    }

}
