package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.WindowsAutopilotDeploymentProfile;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class WindowsAutopilotDeploymentProfileRequest extends EntityRequest<WindowsAutopilotDeploymentProfile> {

    public WindowsAutopilotDeploymentProfileRequest(ContextPath contextPath) {
        super(WindowsAutopilotDeploymentProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsAutopilotDeviceIdentityCollectionRequest assignedDevices() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("assignedDevices"));
    }

    public WindowsAutopilotDeviceIdentityRequest assignedDevices(String id) {
        return new WindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("assignedDevices").addKeys(new NameValue(id.toString())));
    }

    public WindowsAutopilotDeploymentProfileAssignmentCollectionRequest assignments() {
        return new WindowsAutopilotDeploymentProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public WindowsAutopilotDeploymentProfileAssignmentRequest assignments(String id) {
        return new WindowsAutopilotDeploymentProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<String> deviceIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
