package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Windows10GeneralConfiguration;
import odata.msgraph.client.beta.entity.collection.request.WindowsPrivacyDataAccessControlItemCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class Windows10GeneralConfigurationRequest extends EntityRequest<Windows10GeneralConfiguration> {

    public Windows10GeneralConfigurationRequest(ContextPath contextPath) {
        super(Windows10GeneralConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WindowsPrivacyDataAccessControlItemCollectionRequest privacyAccessControls() {
        return new WindowsPrivacyDataAccessControlItemCollectionRequest(
                        contextPath.addSegment("privacyAccessControls"));
    }

    public WindowsPrivacyDataAccessControlItemRequest privacyAccessControls(String id) {
        return new WindowsPrivacyDataAccessControlItemRequest(contextPath.addSegment("privacyAccessControls").addKeys(new NameValue(id.toString())));
    }

}
