package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Vendor;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class VendorRequest extends EntityRequest<Vendor> {

    public VendorRequest(ContextPath contextPath) {
        super(Vendor.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"));
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id.toString())));
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"));
    }

    public PaymentMethodRequest paymentMethod() {
        return new PaymentMethodRequest(contextPath.addSegment("paymentMethod"));
    }

}
