package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.entity.UserTeamwork;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserTeamworkRequest extends EntityRequest<UserTeamwork> {

    public UserTeamworkRequest(ContextPath contextPath) {
        super(UserTeamwork.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"));
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

}
