package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.UserSettings;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserSettingsRequest extends EntityRequest<UserSettings> {

    public UserSettingsRequest(ContextPath contextPath) {
        super(UserSettings.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RegionalAndLanguageSettingsRequest regionalAndLanguageSettings() {
        return new RegionalAndLanguageSettingsRequest(contextPath.addSegment("regionalAndLanguageSettings"));
    }

    public ShiftPreferencesRequest shiftPreferences() {
        return new ShiftPreferencesRequest(contextPath.addSegment("shiftPreferences"));
    }

}
