package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.time.Duration;
import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.AttendeeBase;
import odata.msgraph.client.beta.complex.ConvertIdResult;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementData;
import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.complex.LocationConstraint;
import odata.msgraph.client.beta.complex.MailTips;
import odata.msgraph.client.beta.complex.ManagedAppDiagnosticStatus;
import odata.msgraph.client.beta.complex.ManagedDeviceSummarizedAppState;
import odata.msgraph.client.beta.complex.MeetingTimeSuggestionsResult;
import odata.msgraph.client.beta.complex.Reminder;
import odata.msgraph.client.beta.complex.TimeConstraint;
import odata.msgraph.client.beta.entity.DeviceEnrollmentConfiguration;
import odata.msgraph.client.beta.entity.ManagedAppPolicy;
import odata.msgraph.client.beta.entity.ManagedDevice;
import odata.msgraph.client.beta.entity.Message;
import odata.msgraph.client.beta.entity.User;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppConsentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppIntentAndStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProfilePhotoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.enums.ExchangeIdFormat;
import odata.msgraph.client.beta.enums.MailTipsType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserRequest extends EntityRequest<User> {

    public UserRequest(ContextPath contextPath) {
        super(User.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UserAnalyticsRequest analytics() {
        return new UserAnalyticsRequest(contextPath.addSegment("analytics"));
    }

    public InformationProtectionRequest informationProtection() {
        return new InformationProtectionRequest(contextPath.addSegment("informationProtection"));
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"));
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directReports"));
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id.toString())));
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"));
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectRequest manager() {
        return new DirectoryObjectRequest(contextPath.addSegment("manager"));
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest ownedDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedDevices"));
    }

    public DirectoryObjectRequest ownedDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedDevices").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"));
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest registeredDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredDevices"));
    }

    public DirectoryObjectRequest registeredDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredDevices").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMemberOf() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedRoleMemberOf"));
    }

    public ScopedRoleMembershipRequest scopedRoleMemberOf(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMemberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }

    public OutlookUserRequest outlook() {
        return new OutlookUserRequest(contextPath.addSegment("outlook"));
    }

    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"));
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id.toString())));
    }

    public GroupCollectionRequest joinedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("joinedGroups"));
    }

    public GroupRequest joinedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("joinedGroups").addKeys(new NameValue(id.toString())));
    }

    public MailFolderCollectionRequest mailFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("mailFolders"));
    }

    public MailFolderRequest mailFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("mailFolders").addKeys(new NameValue(id.toString())));
    }

    public CalendarRequest calendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"));
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"));
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id.toString())));
    }

    public CalendarGroupCollectionRequest calendarGroups() {
        return new CalendarGroupCollectionRequest(
                        contextPath.addSegment("calendarGroups"));
    }

    public CalendarGroupRequest calendarGroups(String id) {
        return new CalendarGroupRequest(contextPath.addSegment("calendarGroups").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"));
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"));
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id.toString())));
    }

    public PersonCollectionRequest people() {
        return new PersonCollectionRequest(
                        contextPath.addSegment("people"));
    }

    public PersonRequest people(String id) {
        return new PersonRequest(contextPath.addSegment("people").addKeys(new NameValue(id.toString())));
    }

    public ContactCollectionRequest contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"));
    }

    public ContactRequest contacts(String id) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id.toString())));
    }

    public ContactFolderCollectionRequest contactFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("contactFolders"));
    }

    public ContactFolderRequest contactFolders(String id) {
        return new ContactFolderRequest(contextPath.addSegment("contactFolders").addKeys(new NameValue(id.toString())));
    }

    public InferenceClassificationRequest inferenceClassification() {
        return new InferenceClassificationRequest(contextPath.addSegment("inferenceClassification"));
    }

    public ProfilePhotoRequest photo() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"));
    }

    public ProfilePhotoCollectionRequest photos() {
        return new ProfilePhotoCollectionRequest(
                        contextPath.addSegment("photos"));
    }

    public ProfilePhotoRequest photos(String id) {
        return new ProfilePhotoRequest(contextPath.addSegment("photos").addKeys(new NameValue(id.toString())));
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"));
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id.toString())));
    }

    public SiteCollectionRequest followedSites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("followedSites"));
    }

    public SiteRequest followedSites(String id) {
        return new SiteRequest(contextPath.addSegment("followedSites").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public ApprovalCollectionRequest approvals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("approvals"));
    }

    public ApprovalRequest approvals(String id) {
        return new ApprovalRequest(contextPath.addSegment("approvals").addKeys(new NameValue(id.toString())));
    }

    public AppConsentRequestCollectionRequest appConsentRequestsForApproval() {
        return new AppConsentRequestCollectionRequest(
                        contextPath.addSegment("appConsentRequestsForApproval"));
    }

    public AppConsentRequestRequest appConsentRequestsForApproval(String id) {
        return new AppConsentRequestRequest(contextPath.addSegment("appConsentRequestsForApproval").addKeys(new NameValue(id.toString())));
    }

    public AccessReviewInstanceCollectionRequest pendingAccessReviewInstances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("pendingAccessReviewInstances"));
    }

    public AccessReviewInstanceRequest pendingAccessReviewInstances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("pendingAccessReviewInstances").addKeys(new NameValue(id.toString())));
    }

    public AgreementAcceptanceCollectionRequest agreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("agreementAcceptances"));
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id.toString())));
    }

    public DeviceEnrollmentConfigurationCollectionRequest deviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"));
    }

    public DeviceEnrollmentConfigurationRequest deviceEnrollmentConfigurations(String id) {
        return new DeviceEnrollmentConfigurationRequest(contextPath.addSegment("deviceEnrollmentConfigurations").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"));
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppRegistrationCollectionRequest managedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"));
    }

    public ManagedAppRegistrationRequest managedAppRegistrations(String id) {
        return new ManagedAppRegistrationRequest(contextPath.addSegment("managedAppRegistrations").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionDeviceRegistrationCollectionRequest windowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"));
    }

    public WindowsInformationProtectionDeviceRegistrationRequest windowsInformationProtectionDeviceRegistrations(String id) {
        return new WindowsInformationProtectionDeviceRegistrationRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementTroubleshootingEventCollectionRequest deviceManagementTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("deviceManagementTroubleshootingEvents"));
    }

    public DeviceManagementTroubleshootingEventRequest deviceManagementTroubleshootingEvents(String id) {
        return new DeviceManagementTroubleshootingEventRequest(contextPath.addSegment("deviceManagementTroubleshootingEvents").addKeys(new NameValue(id.toString())));
    }

    public MobileAppIntentAndStateCollectionRequest mobileAppIntentAndStates() {
        return new MobileAppIntentAndStateCollectionRequest(
                        contextPath.addSegment("mobileAppIntentAndStates"));
    }

    public MobileAppIntentAndStateRequest mobileAppIntentAndStates(String id) {
        return new MobileAppIntentAndStateRequest(contextPath.addSegment("mobileAppIntentAndStates").addKeys(new NameValue(id.toString())));
    }

    public MobileAppTroubleshootingEventCollectionRequest mobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"));
    }

    public MobileAppTroubleshootingEventRequest mobileAppTroubleshootingEvents(String id) {
        return new MobileAppTroubleshootingEventRequest(contextPath.addSegment("mobileAppTroubleshootingEvents").addKeys(new NameValue(id.toString())));
    }

    public NotificationCollectionRequest notifications() {
        return new NotificationCollectionRequest(
                        contextPath.addSegment("notifications"));
    }

    public NotificationRequest notifications(String id) {
        return new NotificationRequest(contextPath.addSegment("notifications").addKeys(new NameValue(id.toString())));
    }

    public PlannerUserRequest planner() {
        return new PlannerUserRequest(contextPath.addSegment("planner"));
    }

    public OfficeGraphInsightsRequest insights() {
        return new OfficeGraphInsightsRequest(contextPath.addSegment("insights"));
    }

    public UserSettingsRequest settings() {
        return new UserSettingsRequest(contextPath.addSegment("settings"));
    }

    public OnenoteRequest onenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"));
    }

    public ProfileRequest profile() {
        return new ProfileRequest(contextPath.addSegment("profile"));
    }

    public UserActivityCollectionRequest activities() {
        return new UserActivityCollectionRequest(
                        contextPath.addSegment("activities"));
    }

    public UserActivityRequest activities(String id) {
        return new UserActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public DeviceCollectionRequest devices() {
        return new DeviceCollectionRequest(
                        contextPath.addSegment("devices"));
    }

    public DeviceRequest devices(String id) {
        return new DeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id.toString())));
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"));
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id.toString())));
    }

    public PresenceRequest presence() {
        return new PresenceRequest(contextPath.addSegment("presence"));
    }

    public AuthenticationRequest authentication() {
        return new AuthenticationRequest(contextPath.addSegment("authentication"));
    }

    public ChatCollectionRequest chats() {
        return new ChatCollectionRequest(
                        contextPath.addSegment("chats"));
    }

    public ChatRequest chats(String id) {
        return new ChatRequest(contextPath.addSegment("chats").addKeys(new NameValue(id.toString())));
    }

    public TeamCollectionRequest joinedTeams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("joinedTeams"));
    }

    public TeamRequest joinedTeams(String id) {
        return new TeamRequest(contextPath.addSegment("joinedTeams").addKeys(new NameValue(id.toString())));
    }

    public UserTeamworkRequest teamwork() {
        return new UserTeamworkRequest(contextPath.addSegment("teamwork"));
    }

    @Action(name = "assignLicense")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> assignLicense(List<AssignedLicense> addLicenses, List<String> removeLicenses) {
        Preconditions.checkNotNull(addLicenses, "addLicenses cannot be null");
        Preconditions.checkNotNull(removeLicenses, "removeLicenses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addLicenses", "Collection(microsoft.graph.assignedLicense)", addLicenses)
            .put("removeLicenses", "Collection(Edm.Guid)", removeLicenses)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignLicense"), User.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "changePassword")
    @JsonIgnore
    public ActionRequestNoReturn changePassword(String currentPassword, String newPassword) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("currentPassword", "Edm.String", Checks.checkIsAscii(currentPassword))
            .put("newPassword", "Edm.String", Checks.checkIsAscii(newPassword))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changePassword"), _parameters);
    }

    @Action(name = "invalidateAllRefreshTokens")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> invalidateAllRefreshTokens() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invalidateAllRefreshTokens"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "revokeSignInSessions")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> revokeSignInSessions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeSignInSessions"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "reprocessLicenseAssignment")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> reprocessLicenseAssignment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprocessLicenseAssignment"), User.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "findMeetingTimes")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult> findMeetingTimes(List<AttendeeBase> attendees, LocationConstraint locationConstraint, TimeConstraint timeConstraint, Duration meetingDuration, Integer maxCandidates, Boolean isOrganizerOptional, Boolean returnSuggestionReasons, Double minimumAttendeePercentage) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("attendees", "Collection(microsoft.graph.attendeeBase)", attendees)
            .put("locationConstraint", "microsoft.graph.locationConstraint", locationConstraint)
            .put("timeConstraint", "microsoft.graph.timeConstraint", timeConstraint)
            .put("meetingDuration", "Edm.Duration", meetingDuration)
            .put("maxCandidates", "Edm.Int32", maxCandidates)
            .put("isOrganizerOptional", "Edm.Boolean", isOrganizerOptional)
            .put("returnSuggestionReasons", "Edm.Boolean", returnSuggestionReasons)
            .put("minimumAttendeePercentage", "Edm.Double", minimumAttendeePercentage)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findMeetingTimes"), MeetingTimeSuggestionsResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "sendMail")
    @JsonIgnore
    public ActionRequestNoReturn sendMail(Message message, Boolean saveToSentItems) {
        Preconditions.checkNotNull(message, "message cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("SaveToSentItems", "Edm.Boolean", saveToSentItems)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendMail"), _parameters);
    }

    @Action(name = "getMailTips")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailTips> getMailTips(List<String> emailAddresses, MailTipsType mailTipsOptions) {
        Preconditions.checkNotNull(emailAddresses, "emailAddresses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EmailAddresses", "Collection(Edm.String)", Checks.checkIsAscii(emailAddresses))
            .put("MailTipsOptions", "microsoft.graph.mailTipsType", mailTipsOptions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailTips"), MailTips.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "translateExchangeIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ConvertIdResult> translateExchangeIds(List<String> inputIds, ExchangeIdFormat targetIdType, ExchangeIdFormat sourceIdType) {
        Preconditions.checkNotNull(inputIds, "inputIds cannot be null");
        Preconditions.checkNotNull(targetIdType, "targetIdType cannot be null");
        Preconditions.checkNotNull(sourceIdType, "sourceIdType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputIds", "Collection(Edm.String)", Checks.checkIsAscii(inputIds))
            .put("TargetIdType", "microsoft.graph.exchangeIdFormat", targetIdType)
            .put("SourceIdType", "microsoft.graph.exchangeIdFormat", sourceIdType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.translateExchangeIds"), ConvertIdResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "removeAllDevicesFromManagement")
    @JsonIgnore
    public ActionRequestNoReturn removeAllDevicesFromManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeAllDevicesFromManagement"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationByDeviceTag"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationsByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationsByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationsByDeviceTag"), _parameters);
    }

    @Action(name = "wipeAndBlockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn wipeAndBlockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeAndBlockManagedApps"), _parameters);
    }

    @Action(name = "unblockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn unblockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unblockManagedApps"), _parameters);
    }

    @Action(name = "exportPersonalData")
    @JsonIgnore
    public ActionRequestNoReturn exportPersonalData(String storageLocation) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("storageLocation", "Edm.String", Checks.checkIsAscii(storageLocation))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportPersonalData"), _parameters);
    }

    @Function(name = "reminderView")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Reminder> reminderView(String startDateTime, String endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("EndDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reminderView"), Reminder.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "findRoomLists")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRoomLists() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRoomLists"), EmailAddress.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms_Function(String roomList) {
        Preconditions.checkNotNull(roomList, "roomList cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RoomList", "Edm.String", Checks.checkIsAscii(roomList))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData_Function(Integer skip, Integer top) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEffectiveDeviceEnrollmentConfigurations")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceEnrollmentConfiguration> getEffectiveDeviceEnrollmentConfigurations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectiveDeviceEnrollmentConfigurations"), DeviceEnrollmentConfiguration.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getLoggedOnManagedDevices")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDevice> getLoggedOnManagedDevices() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getLoggedOnManagedDevices"), ManagedDevice.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedAppDiagnosticStatuses")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppDiagnosticStatus> getManagedAppDiagnosticStatuses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppDiagnosticStatuses"), ManagedAppDiagnosticStatus.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedAppPolicies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppPolicy> getManagedAppPolicies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppPolicies"), ManagedAppPolicy.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "isManagedAppUserBlocked")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isManagedAppUserBlocked() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isManagedAppUserBlocked"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedDevicesWithAppFailures")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getManagedDevicesWithAppFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithAppFailures"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedDevicesWithFailedOrPendingApps")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDeviceSummarizedAppState> getManagedDevicesWithFailedOrPendingApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithFailedOrPendingApps"), ManagedDeviceSummarizedAppState.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
