package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserInstallStateSummary;
import odata.msgraph.client.beta.entity.collection.request.DeviceInstallStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserInstallStateSummaryRequest extends EntityRequest<UserInstallStateSummary> {

    public UserInstallStateSummaryRequest(ContextPath contextPath) {
        super(UserInstallStateSummary.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(
                        contextPath.addSegment("deviceStates"));
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

}
