package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsCategory;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserExperienceAnalyticsCategoryRequest extends EntityRequest<UserExperienceAnalyticsCategory> {

    public UserExperienceAnalyticsCategoryRequest(ContextPath contextPath) {
        super(UserExperienceAnalyticsCategory.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UserExperienceAnalyticsMetricCollectionRequest metricValues() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("metricValues"));
    }

    public UserExperienceAnalyticsMetricRequest metricValues(String id) {
        return new UserExperienceAnalyticsMetricRequest(contextPath.addSegment("metricValues").addKeys(new NameValue(id.toString())));
    }

}
