package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsBaseline;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserExperienceAnalyticsBaselineRequest extends EntityRequest<UserExperienceAnalyticsBaseline> {

    public UserExperienceAnalyticsBaselineRequest(ContextPath contextPath) {
        super(UserExperienceAnalyticsBaseline.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UserExperienceAnalyticsCategoryRequest deviceBootPerformanceMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("deviceBootPerformanceMetrics"));
    }

    public UserExperienceAnalyticsCategoryRequest bestPracticesMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("bestPracticesMetrics"));
    }

}
