package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserAppInstallStatus;
import odata.msgraph.client.beta.entity.collection.request.MobileAppInstallStatusCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserAppInstallStatusRequest extends EntityRequest<UserAppInstallStatus> {

    public UserAppInstallStatusRequest(ContextPath contextPath) {
        super(UserAppInstallStatus.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MobileAppRequest app() {
        return new MobileAppRequest(contextPath.addSegment("app"));
    }

    public MobileAppInstallStatusCollectionRequest deviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    public MobileAppInstallStatusRequest deviceStatuses(String id) {
        return new MobileAppInstallStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

}
