package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserAnalytics;
import odata.msgraph.client.beta.entity.collection.request.ActivityStatisticsCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserAnalyticsRequest extends EntityRequest<UserAnalytics> {

    public UserAnalyticsRequest(ContextPath contextPath) {
        super(UserAnalytics.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ActivityStatisticsCollectionRequest activityStatistics() {
        return new ActivityStatisticsCollectionRequest(
                        contextPath.addSegment("activityStatistics"));
    }

    public ActivityStatisticsRequest activityStatistics(String id) {
        return new ActivityStatisticsRequest(contextPath.addSegment("activityStatistics").addKeys(new NameValue(id.toString())));
    }

}
