package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserActivity;
import odata.msgraph.client.beta.entity.collection.request.ActivityHistoryItemCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UserActivityRequest extends EntityRequest<UserActivity> {

    public UserActivityRequest(ContextPath contextPath) {
        super(UserActivity.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ActivityHistoryItemCollectionRequest historyItems() {
        return new ActivityHistoryItemCollectionRequest(
                        contextPath.addSegment("historyItems"));
    }

    public ActivityHistoryItemRequest historyItems(String id) {
        return new ActivityHistoryItemRequest(contextPath.addSegment("historyItems").addKeys(new NameValue(id.toString())));
    }

}
