package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignment;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UnifiedRoleAssignmentRequest extends EntityRequest<UnifiedRoleAssignment> {

    public UnifiedRoleAssignmentRequest(ContextPath contextPath) {
        super(UnifiedRoleAssignment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UnifiedRoleDefinitionRequest roleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    public DirectoryObjectRequest principal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"));
    }

    public DirectoryObjectRequest directoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"));
    }

    public AppScopeRequest appScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"));
    }

}
