package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignmentMultiple;
import odata.msgraph.client.beta.entity.collection.request.AppScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class UnifiedRoleAssignmentMultipleRequest extends EntityRequest<UnifiedRoleAssignmentMultiple> {

    public UnifiedRoleAssignmentMultipleRequest(ContextPath contextPath) {
        super(UnifiedRoleAssignmentMultiple.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UnifiedRoleDefinitionRequest roleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    public DirectoryObjectCollectionRequest principals() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("principals"));
    }

    public DirectoryObjectRequest principals(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("principals").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest directoryScopes() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directoryScopes"));
    }

    public DirectoryObjectRequest directoryScopes(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScopes").addKeys(new NameValue(id.toString())));
    }

    public AppScopeCollectionRequest appScopes() {
        return new AppScopeCollectionRequest(
                        contextPath.addSegment("appScopes"));
    }

    public AppScopeRequest appScopes(String id) {
        return new AppScopeRequest(contextPath.addSegment("appScopes").addKeys(new NameValue(id.toString())));
    }

}
