package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.TrustFramework;
import odata.msgraph.client.beta.entity.collection.request.TrustFrameworkKeySetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TrustFrameworkPolicyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class TrustFrameworkRequest extends EntityRequest<TrustFramework> {

    public TrustFrameworkRequest(ContextPath contextPath) {
        super(TrustFramework.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TrustFrameworkPolicyCollectionRequest policies() {
        return new TrustFrameworkPolicyCollectionRequest(
                        contextPath.addSegment("policies"));
    }

    public TrustFrameworkPolicyRequest policies(String id) {
        return new TrustFrameworkPolicyRequest(contextPath.addSegment("policies").addKeys(new NameValue(id.toString())));
    }

    public TrustFrameworkKeySetCollectionRequest keySets() {
        return new TrustFrameworkKeySetCollectionRequest(
                        contextPath.addSegment("keySets"));
    }

    public TrustFrameworkKeySetRequest keySets(String id) {
        return new TrustFrameworkKeySetRequest(contextPath.addSegment("keySets").addKeys(new NameValue(id.toString())));
    }

}
