package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.TrustFrameworkKey;
import odata.msgraph.client.beta.entity.TrustFrameworkKeySet;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class TrustFrameworkKeySetRequest extends EntityRequest<TrustFrameworkKeySet> {

    public TrustFrameworkKeySetRequest(ContextPath contextPath) {
        super(TrustFrameworkKeySet.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "generateKey")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> generateKey(String use, String kty, Long nbf, Long exp) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("use", "Edm.String", Checks.checkIsAscii(use))
            .put("kty", "Edm.String", Checks.checkIsAscii(kty))
            .put("nbf", "Edm.Int64", nbf)
            .put("exp", "Edm.Int64", exp)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateKey"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "uploadSecret")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> uploadSecret(String use, String k, Long nbf, Long exp) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("use", "Edm.String", Checks.checkIsAscii(use))
            .put("k", "Edm.String", Checks.checkIsAscii(k))
            .put("nbf", "Edm.Int64", nbf)
            .put("exp", "Edm.Int64", exp)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadSecret"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "uploadCertificate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> uploadCertificate(String key) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadCertificate"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "uploadPkcs12")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> uploadPkcs12(String key, String password) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadPkcs12"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getActiveKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> getActiveKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActiveKey"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
