package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ThreatAssessmentRequest;
import odata.msgraph.client.beta.entity.collection.request.ThreatAssessmentResultCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ThreatAssessmentRequestRequest extends EntityRequest<ThreatAssessmentRequest> {

    public ThreatAssessmentRequestRequest(ContextPath contextPath) {
        super(ThreatAssessmentRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ThreatAssessmentResultCollectionRequest results() {
        return new ThreatAssessmentResultCollectionRequest(
                        contextPath.addSegment("results"));
    }

    public ThreatAssessmentResultRequest results(String id) {
        return new ThreatAssessmentResultRequest(contextPath.addSegment("results").addKeys(new NameValue(id.toString())));
    }

}
