package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.TermsAndConditions;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsAcceptanceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class TermsAndConditionsRequest extends EntityRequest<TermsAndConditions> {

    public TermsAndConditionsRequest(ContextPath contextPath) {
        super(TermsAndConditions.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TermsAndConditionsGroupAssignmentCollectionRequest groupAssignments() {
        return new TermsAndConditionsGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"));
    }

    public TermsAndConditionsGroupAssignmentRequest groupAssignments(String id) {
        return new TermsAndConditionsGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id.toString())));
    }

    public TermsAndConditionsAssignmentCollectionRequest assignments() {
        return new TermsAndConditionsAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public TermsAndConditionsAssignmentRequest assignments(String id) {
        return new TermsAndConditionsAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public TermsAndConditionsAcceptanceStatusCollectionRequest acceptanceStatuses() {
        return new TermsAndConditionsAcceptanceStatusCollectionRequest(
                        contextPath.addSegment("acceptanceStatuses"));
    }

    public TermsAndConditionsAcceptanceStatusRequest acceptanceStatuses(String id) {
        return new TermsAndConditionsAcceptanceStatusRequest(contextPath.addSegment("acceptanceStatuses").addKeys(new NameValue(id.toString())));
    }

}
