package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Teamwork;
import odata.msgraph.client.beta.entity.collection.request.WorkforceIntegrationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class TeamworkRequest extends EntityRequest<Teamwork> {

    public TeamworkRequest(ContextPath contextPath) {
        super(Teamwork.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkforceIntegrationCollectionRequest workforceIntegrations() {
        return new WorkforceIntegrationCollectionRequest(
                        contextPath.addSegment("workforceIntegrations"));
    }

    public WorkforceIntegrationRequest workforceIntegrations(String id) {
        return new WorkforceIntegrationRequest(contextPath.addSegment("workforceIntegrations").addKeys(new NameValue(id.toString())));
    }

}
