package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.TeamsApp;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class TeamsAppRequest extends EntityRequest<TeamsApp> {

    public TeamsAppRequest(ContextPath contextPath) {
        super(TeamsApp.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TeamsAppDefinitionCollectionRequest appDefinitions() {
        return new TeamsAppDefinitionCollectionRequest(
                        contextPath.addSegment("appDefinitions"));
    }

    public TeamsAppDefinitionRequest appDefinitions(String id) {
        return new TeamsAppDefinitionRequest(contextPath.addSegment("appDefinitions").addKeys(new NameValue(id.toString())));
    }

}
