package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.TeamsAppInstallation;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class TeamsAppInstallationRequest extends EntityRequest<TeamsAppInstallation> {

    public TeamsAppInstallationRequest(ContextPath contextPath) {
        super(TeamsAppInstallation.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TeamsAppRequest teamsApp() {
        return new TeamsAppRequest(contextPath.addSegment("teamsApp"));
    }

    public TeamsAppDefinitionRequest teamsAppDefinition() {
        return new TeamsAppDefinitionRequest(contextPath.addSegment("teamsAppDefinition"));
    }

    @Action(name = "upgrade")
    @JsonIgnore
    public ActionRequestNoReturn upgrade() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.upgrade"), _parameters);
    }

}
