package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.AttributeDefinition;
import odata.msgraph.client.beta.complex.ExpressionInputObject;
import odata.msgraph.client.beta.complex.ParseExpressionResponse;
import odata.msgraph.client.beta.entity.AttributeMappingFunctionSchema;
import odata.msgraph.client.beta.entity.FilterOperatorSchema;
import odata.msgraph.client.beta.entity.SynchronizationSchema;
import odata.msgraph.client.beta.entity.collection.request.DirectoryDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SynchronizationSchemaRequest extends EntityRequest<SynchronizationSchema> {

    public SynchronizationSchemaRequest(ContextPath contextPath) {
        super(SynchronizationSchema.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DirectoryDefinitionCollectionRequest directories() {
        return new DirectoryDefinitionCollectionRequest(
                        contextPath.addSegment("directories"));
    }

    public DirectoryDefinitionRequest directories(String id) {
        return new DirectoryDefinitionRequest(contextPath.addSegment("directories").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "parseExpression")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ParseExpressionResponse> parseExpression(String expression, ExpressionInputObject testInputObject, AttributeDefinition targetAttributeDefinition) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("expression", "Edm.String", Checks.checkIsAscii(expression))
            .put("testInputObject", "microsoft.graph.expressionInputObject", testInputObject)
            .put("targetAttributeDefinition", "microsoft.graph.attributeDefinition", targetAttributeDefinition)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ParseExpressionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.parseExpression"), ParseExpressionResponse.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "functions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttributeMappingFunctionSchema> functions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.functions"), AttributeMappingFunctionSchema.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "filterOperators")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FilterOperatorSchema> filterOperators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterOperators"), FilterOperatorSchema.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
